//
//  Date+Extension.swift
//  QIWI
//
//  Created by Ilkhom on 04/03/22.
//

import Foundation

extension Date {
    
    func getDateComponent(_ components: Calendar.Component..., calendar: Calendar = Calendar.current) -> DateComponents {
        return calendar.dateComponents(Set(components), from: self)
    }

    func getDateComponent(_ component: Calendar.Component, calendar: Calendar = Calendar.current) -> Int {
        return calendar.component(component, from: self)
    }
    
    func startOfMonth() -> Date {
        return Calendar.current.date(from: Calendar.current.dateComponents([.year, .month], from: Calendar.current.startOfDay(for: self)))!
    }
    
    func endOfMonth() -> Date {
        return Calendar.current.date(byAdding: DateComponents(month: 1, day: -1), to: self.startOfMonth())!
    }
    
    func isInPastWeek() -> Bool {
        let week = Calendar(identifier: .gregorian).date(byAdding: .day, value: -7, to: Date()) ?? Date()
        return (week ... Date()).contains(self)
    }
    
    func isInPastMonth() -> Bool {
        let month = Calendar(identifier: .gregorian).date(byAdding: .month, value: -1, to: Date()) ?? Date()
        return (month ... Date()).contains(self)
    }
    
    func convertToLocalTime(fromTimeZone timeZoneAbbreviation: String) -> Date? {
        if let timeZone = TimeZone(abbreviation: timeZoneAbbreviation) {
            let targetOffset = TimeInterval(timeZone.secondsFromGMT(for: self))
            let localOffeset = TimeInterval(TimeZone.autoupdatingCurrent.secondsFromGMT(for: self))

            return self.addingTimeInterval(targetOffset - localOffeset)
        }

        return nil
    }
    
    func toString(format: String, timeZone: String? = "GMT") -> String {
        let formatter = DateFormatter()
        formatter.timeZone = TimeZone(identifier: timeZone ?? "GMT")
        formatter.dateFormat = format
        return formatter.string(from: self)
    }
}
