//
//  Numeric+Extensions.swift
//  QIWI
//
//  Created by Ilkhom on 05/04/22.
//

#if os(iOS)
import UIKit

//MARK: - Part below converts 1000000 -> 1 000 000
extension Formatter {

    static let withSeparator: NumberFormatter = {
        let formatter = NumberFormatter()
        formatter.numberStyle = .decimal
        formatter.groupingSeparator = " "
        return formatter
    }()
    
}
extension Numeric {
    var separated: String { Formatter.withSeparator.string(for: self) ?? "" }
}


//MARK: - Dynamic Fonts Sizes
fileprivate let baseDeviceHeight: CGFloat = UIScreen.main.bounds.height
fileprivate let baseDeviceWidth: CGFloat = UIScreen.main.bounds.width

public extension CGFloat {
    
    var dfs: CGFloat {
        return CGFloat.getDynamicFontSize(size: self)
    }
    
    var dvs: CGFloat {
        return CGFloat.getDynamicVerticalSize(size: self)
    }
    
    var dhs: CGFloat {
        return CGFloat.getDynamicHorizontalSize(size: self)
    }
    
    // Minimum visible font size is 11
    fileprivate static func getDynamicFontSize(size: CGFloat) -> CGFloat{
        return (CGFloat.maximum(11, size * UIScreen.main.bounds.height / baseDeviceHeight))
    }
    
    fileprivate static func getDynamicVerticalSize(size: CGFloat) -> CGFloat{
        return (size * UIScreen.main.bounds.height / baseDeviceHeight)
    }
    
    fileprivate static func getDynamicHorizontalSize(size: CGFloat) -> CGFloat{
        return (size * UIScreen.main.bounds.width / baseDeviceWidth)
    }
}

public extension Int {
    
    var dfs: CGFloat {
        return CGFloat.getDynamicFontSize(size: CGFloat(self))
    }
    
    var dvs: CGFloat {
        return CGFloat.getDynamicVerticalSize(size: CGFloat(self))
    }
    
    var dhs: CGFloat {
        return CGFloat.getDynamicHorizontalSize(size: CGFloat(self))
    }
}

public extension Double {
    
    var dfs: CGFloat {
        return CGFloat.getDynamicFontSize(size: CGFloat(self))
    }
    
    var dvs: CGFloat {
        return CGFloat.getDynamicVerticalSize(size: CGFloat(self))
    }
    
    var dhs: CGFloat {
        return CGFloat.getDynamicHorizontalSize(size: CGFloat(self))
    }
}


#endif
