//
//  String+Extension.swift
//  test
//
//  Created by Ilkhom on 01/03/22.
//

import Foundation

public extension String {
    
    var alphabetic: String {
        components(separatedBy: CharacterSet.decimalDigits).joined()
    }
    
    var alphanumeric: String {
        components(separatedBy: CharacterSet.alphanumerics.inverted).joined()
    }
    
    var digits: String {
        components(separatedBy: CharacterSet.decimalDigits.inverted).joined()
    }
    
    var trimmed: String {
         self.trimmingCharacters(in: .whitespacesAndNewlines)
    }
}


//MARK: - DATEs
extension String {
    func toDate(format: String, locale: String = "en_US", timeZone: String = "GMT") -> Date {
        let formatter = DateFormatter()
        formatter.locale = Locale(identifier: locale)
        formatter.timeZone = TimeZone(identifier: timeZone)
        formatter.dateFormat = format
        
        let date =  (formatter.date(from: self) ?? Date()).convertToLocalTime(fromTimeZone: timeZone)
        return date ?? Date()
    }
    
    func convertDate(_ fromFormat: String, to format: String) -> String {
        let date = self.toDate(format: fromFormat)
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = format
        return dateFormatter.string(from: date)
        
    }
}



//MARK: - URL encoding String it contains nonlatin letters
extension String {
    var encodeUrl: String {
        return self.addingPercentEncoding(withAllowedCharacters: NSCharacterSet.urlQueryAllowed)!
    }
    
    var decodeUrl:  String {
        return self.removingPercentEncoding!
    }
}


//MARK: - encoding if String contains emojis
extension String {
    var encode: String {
        let data = self.data(using: .nonLossyASCII, allowLossyConversion: true) ?? Data()
        return String(data: data, encoding: .utf8) ?? ""
    }
    
    var decode: String {
        let data = self.data(using: .utf8) ?? Data()
        return String(data: data, encoding: .nonLossyASCII) ?? ""
    }
}
