//
//  StringFormatter.swift
//  QIWI
//
//  Created by Ilkhom on 15/03/22.
//

import Foundation

extension String {
    func toTiins() -> Int {
        self.toInt() * 100
    }
    
    func toInt() -> Int {
        return (self.noSpaces() as NSString).integerValue
    }
    
    func toDouble() -> Double {
        return (self.noSpaces().replacingOccurrences(of: ",", with: ".") as NSString).doubleValue
    }

    func noSpaces() -> String {
        self.replacingOccurrences(of: " ", with: "")
    }
}


//MARK: - PHONE
extension String {
    func addUzbekPrefixIfNeeded() -> String {
        let digits = self.digits
        if digits.count == 9 {
            return "998" + digits
        }
        return digits
    }
    
    func removeUzbekPrefixIfNeeded() -> String {
        let digits = self.digits
        if digits.count == 12 {
            return String(digits.dropFirst(3))
        }
        return digits
    }
    
    var isUzPhoneNumber: Bool {
        self.digits.count == 9 || self.digits.count == 12 && self.starts(with: "998")
    }
    
    var isRuPhoneNumber: Bool {
        self.digits.count == 11 && self.digits.starts(with: "7")
    }
    
    func asPhone(masks: [String]) -> String {
        let formatter = TextFieldFormatter()
        return formatter.formatString(ofNumbers: self, withMasks: masks)
    }
}


//MARK: - CARD
extension String {
    func asCardNumber() -> String {
        self.replacingOccurrences(of: "(\\d{4})(\\d{4})(\\d{4})(\\d+)", with: "$1 $2 $3 $4", options: .regularExpression, range: nil)
    }
    
    func asMaskedCardNumber() -> String {
        var result = ""
        self.enumerated().forEach { (index, character) in
            if index > 6 && index < 12 {
                result += "*"
            } else {
                result.append(character)
            }
        }
        
        return result
    }
    
    func asSeparatedMaskedCardNumber() -> String {
        var result = ""
        self.asMaskedCardNumber().enumerated().forEach { (index, character) in
            if index % 4 == 0 && index > 0 {
                result += " "
            }
            result.append(character)
        }
        
        return result
    }
    
    func asCardExpiry() -> String {
        var result = ""
        self.enumerated().forEach { (index, character) in
            if index % 2 == 0 && index > 0 {
                result += "/"
            }

            result.append(character)
        }
        
        return result
    }
}
