//
//  TextFieldFormatter.swift
//  QIWI
//
//  Created by Ilkhom on 02/03/22.
//

import Foundation

class TextFieldFormatter {
    
    func formatString(ofNumbers string: String, withMasks masks: [String]) -> String {
        let numbers = getNumbers(string)
		guard let mask = masks.first(where: { $0.count(of: "X") == numbers.count || $0.count(of: "#") == numbers.count }) else {
			return numbers
		}
        return formatStringInternal(numbers: numbers, mask: mask)
    }
	
	func formatString(ofNumbers string: String, withMask mask: String) -> String {
		let numbers = getNumbers(string)
		return formatStringInternal(numbers: numbers, mask: mask)
	}
	
	private func formatStringInternal(numbers: String, mask: String) -> String {
		var result = ""
		var index = numbers.startIndex
		for ch in mask where index < numbers.endIndex {
			if ch == "X" || ch == "#" {
				result.append(numbers[index])
				index = numbers.index(after: index)
			} else {
				result.append(ch)
			}
		}
		return result
	}
	
	private func getNumbers(_ string: String) -> String {
		string.noSpaces().replacingOccurrences(of: "[^0-9 || A-Za-z]", with: "", options: .regularExpression)
	}

    ///ex. passport data `AAXXXXXXX` - A - seria X - number
    func format(with mask: String, passport: String) -> String {
        var result = ""
        var index = passport.startIndex
        for ch in mask where index < passport.endIndex {
            if ch == "X" && passport[index].isNumber {
                result.append(passport[index])
                index = passport.index(after: index)
            } else if ch == "A" && passport[index].isASCII && passport[index].isLetter {
                result.append(passport[index].uppercased())
                index = passport.index(after: index)
            } else {
                break
            }
        }
        return result
    }

}

private extension String {
	func count(of char: Character) -> Int {
		return reduce(0) {
			$1 == char ? $0 + 1 : $0
		}
	}
}
