//
//  Validators.swift
//  QIWI
//
//  Created by Ilkhom on 03/03/22.
//

import Foundation

public extension String {
    
    func isValidEmail() -> Bool {
        let regex = try! NSRegularExpression(pattern: "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,64}", options: .caseInsensitive)
        return regex.firstMatch(in: self, options: [], range: NSRange(location: 0, length: count)) != nil
    }
    
    func isValidShortUzPhone() -> Bool {
        let regex = "^[0-9]{9}$"
        let test = NSPredicate(format: "SELF MATCHES %@", regex)
        return test.evaluate(with: self.digits)
    }
    
    func isValidPhone() -> Bool {
        let regex = "^[0-9]{12}$"
        let test = NSPredicate(format: "SELF MATCHES %@", regex)
        return test.evaluate(with: self.digits)
    }
    
    func isValidPassword() -> Bool {
        do {
            let regex = try NSRegularExpression(pattern: "^[a-zA-Z_0-9\\-_,;.:#+*?=!§$%&/()@]+$", options: .caseInsensitive)
            if(regex.firstMatch(in: self, options: NSRegularExpression.MatchingOptions(rawValue: 0), range: NSMakeRange(0, self.count)) != nil){
                return self.count>=6 && self.count<=20
            }else{
                return false
            }
        } catch {
            return false
        }
    }
    
    func isValidPassportSeria() -> Bool {
        self.alphabetic.count == 2
    }
    
    func isValidPassportNumber() -> Bool {
        self.digits.count == 7
    }
    
    func isValidPassportPinfl() -> Bool {
        self.digits.count == 14
    }
    
    func isValidPassport() -> Bool {
        self.noSpaces().count == 9
    }
    
    func isValidDate(format: String) -> Bool {
        let formatter = DateFormatter()
        formatter.dateFormat = format
        let date = formatter.date(from: self)
        
        guard let date = date else { return false }

        return date.getDateComponent(.day) <= 31
                && date.getDateComponent(.month) <= 12
                && (1900...Date().getDateComponent(.year)).contains(date.getDateComponent(.year))
    }
    
    func isValidAmount(max: Int, min: Int) -> Bool {
        if self.isEmpty || min > max { return false }
        let range = min...max
        return range.contains(self.digits.toInt())
    }
    
    func isValidCardNumber() -> Bool {
        self.noSpaces().digits.count == 16
    }
    
    func isValidCardExpiry() -> Bool {
        self.digits.count == 4
    }
    
    func isValidCardCVV() -> Bool {
        self.digits.count == 3
    }

    
}
