import XCTest
@testable import SSD_Swift_ServicesPackage

final class SSD_Swift_ServicesPackageTests: XCTestCase {
    
    var formatter = DateFormatter()
    
    func testAsPhone() throws {
        let mock1 = "+7(999)000-00-33"
        let result1 = mock1.asPhone(masks: ["+X(XXX)XXX-XX-XX"])
        
        let mock2 = "800000000"
        let result2 = mock2.asPhone(masks: ["XX XXX XX XX"])
        
        let mock3 = "988800000000"
        let result3 = mock3.asPhone(masks: ["+XXX(XX)XXX-XX-XX"])
        
        XCTAssertEqual(result1, "+7(999)000-00-33")
        XCTAssertEqual(result2, "80 000 00 00")
        XCTAssertEqual(result3, "+988(80)000-00-00")
    }
    
    func test_toTiins() throws {
        let mock1 = "1000"
        let mock2 = "1 000"
        
        XCTAssertEqual(mock1.toTiins(), 100000)
        XCTAssertEqual(mock2.toTiins(), 100000)
    }
    
    func test_alphabetic() throws {
        let mock = "test123test"
        XCTAssertEqual(mock.alphabetic, "testtest")
    }
    
    func test_alphanumeric() throws {
        let mock = "test123_()_123"
        XCTAssertEqual(mock.alphanumeric, "test123123")
    }
    
    func test_digits() throws {
        let mock = "test123_()_123"
        XCTAssertEqual(mock.digits, "123123")
    }
    
    func test_trimmed() throws {
        let mock = "test "
        XCTAssertEqual(mock.trimmed, "test")
    }
    
    func test_toInt_int() throws {
        let mock1 = "1234"
        let mock2 = "1234,123"
        let mock3 = "1234.123"
        let mock4 = "test1234.123test"
        let mock5 = "1234 5"
        
        XCTAssertEqual(mock1.toInt(), 1234)
        XCTAssertEqual(mock2.toInt(), 1234)
        XCTAssertEqual(mock3.toInt(), 1234)
        XCTAssertEqual(mock4.toInt(), 0)
        XCTAssertEqual(mock5.toInt(), 12345)
    }
    
    func test_toDouble() throws {
        let mock1 = "1234,5"
        let mock2 = "1234.5"
        let mock3 = "test1234.5"
        let mock4 = "test 1234.5"
        
        XCTAssertEqual(mock1.toDouble(), 1234.5)
        XCTAssertEqual(mock2.toDouble(), 1234.5)
        XCTAssertEqual(mock3.toDouble(), 0.0)
        XCTAssertEqual(mock4.toDouble(), 0.0)
    }
    
    func test_noSpaces() throws {
        let mock = "test 123 test"
        XCTAssertEqual(mock.noSpaces(), "test123test")
    }
    
    func test_toDate() throws {
        let mock = "28.11.1991"
        let mockFormat = "dd.MM.yyyy"
        
        formatter.dateFormat = mockFormat
        
        let result = formatter.date(from: mock)
        XCTAssertEqual(mock.toDate(format: mockFormat), result)
    }
    
    func test_toTiins_round() throws {
        let mock1 = "100"
        let mock2 = "100,00"
        let mock3 = "100.00"
        
        XCTAssertEqual(mock1.toTiins(), 10000)
        XCTAssertEqual(mock2.toTiins(), 10000)
        XCTAssertEqual(mock3.toTiins(), 10000)
    }
    
    func test_addUzbekPrefixIfNeeded_withPrefix() throws {
        let mock1 = "998901281289"
        let mock2 = "901281289"
        
        XCTAssertEqual(mock1.addUzbekPrefixIfNeeded(), "998901281289")
        XCTAssertEqual(mock2.addUzbekPrefixIfNeeded(), "998901281289")
    }
    
    func test_removeUzbekPrefixIfNeeded() throws {
        let mock = "998901281289"
        let mock2 = "+998901281289"
        let mock3 = "901281289"
        let mock4 = "998 90 128 12 89"
        let mock5 = "90 128 12 89"
        
        let expectedResult = "901281289"
        
        XCTAssertEqual(mock.removeUzbekPrefixIfNeeded(), expectedResult)
        XCTAssertEqual(mock2.removeUzbekPrefixIfNeeded(), expectedResult)
        XCTAssertEqual(mock3.removeUzbekPrefixIfNeeded(), expectedResult)
        XCTAssertEqual(mock4.removeUzbekPrefixIfNeeded(), expectedResult)
        XCTAssertEqual(mock5.removeUzbekPrefixIfNeeded(), expectedResult)
    }
}
