package uz.mobiuz.mobiservice.dev.model

import uz.mobiuz.mobiservice.dev.app.App
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS

data class ServiceData (
    val id:Int,
    val title:Translate,
    val short_description:Translate,
    val data: List<InnerData>
)

data class Translate(
    val uz:String,
    val ru:String,
    val en:String
){
    fun getTranslated():String{
        return when (SharedPref(App.INSTANCE).language) {
            CONSTANTS.EN -> this.en
            CONSTANTS.RU -> this.ru
            else -> this.uz
        }
    }
}

data class InnerData(
    val title:Translate,
    val data: List<UssdData>
)

data class UssdData(
    val title:Translate,
    val short_description:Translate,
    val code: String,
    val limit: Int)