package uz.ssd.mobiuz.network.repository

import android.content.Context
import dagger.hilt.android.qualifiers.ApplicationContext
import uz.ssd.mobiuz.model.UserAuth
import uz.ssd.mobiuz.network.api.ApiService
import uz.ssd.mobiuz.network.model.UiStateObject
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class AuthRepository @Inject constructor(
    private val apiService: ApiService,
    @ApplicationContext val context: Context
) {

    suspend fun loginUser(data: UserAuth): UiStateObject<String> {
        return try {
            val res = apiService.login(data)
            when (res.status.code) {
                200 -> {
                    UiStateObject.SUCCESS(res.status.message)
                }

                else -> UiStateObject.SUCCESS(res.status.message)
            }
        } catch (e: Exception) {
            UiStateObject.SUCCESS("res.message")
        }

    }

}