package uz.ssd.mobiuz.ui.auth

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import uz.ssd.mobiuz.model.UserAuth
import uz.ssd.mobiuz.network.model.UiStateObject
import uz.ssd.mobiuz.network.repository.AuthRepository
import javax.inject.Inject

@HiltViewModel
class AuthViewModel @Inject constructor(
    private val repository: AuthRepository
) : ViewModel() {

    private val _loginUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val loginUiState: StateFlow<UiStateObject<String>> = _loginUiState

    fun login(data: UserAuth) = viewModelScope.launch {
        _loginUiState.value = UiStateObject.LOADING
        delay(1000)
        _loginUiState.value = repository.loginUser(data)
        _loginUiState.value = UiStateObject.EMPTY
    }
}