package com.mobiuz.app.dev.ui.settings

import android.os.Bundle
import android.view.View
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentProfileBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.utils.extensions.customMasket
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject


@AndroidEntryPoint
class ProfileFragment : BaseFragment(R.layout.fragment_profile) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentProfileBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentProfileBinding.bind(view)
        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            txtUserPhone.text = pref.userPhone.customMasket()
            txtUserName.text = pref.userName
            txtAvatar.text = pref.userName[0].toString()
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }
            btn0890.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                }
            })
            btn0890.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                }
            })
            btnEmail.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                }
            })
            btnSim.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                }
            })

        }
    }


    override fun collects() {
    }


    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}