package uz.mobiuz.mobiservice.dev.ui.settings

import android.os.Bundle
import android.view.View
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.FragmentProfileBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.ui.base.BaseFragment
import uz.mobiuz.mobiservice.dev.utils.extensions.customMasket
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject


@AndroidEntryPoint
class ProfileFragment : BaseFragment(R.layout.fragment_profile) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentProfileBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentProfileBinding.bind(view)
        setUpUI()
        collects()
    }

    override fun setUpUI() {
        bn.apply {
            txtUserPhone.text = pref.userPhone.customMasket()
            txtUserName.text = pref.userName
            txtBirthday.text = pref.userBirthday
            txtAvatar.text = pref.userName[0].toString()
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }
        }
    }


    override fun collects() {
    }


    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}