package com.mobiuz.app.dev.ui.service.ussd

import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentMainUssdBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.service.UssdBottomSheetDialog
import com.mobiuz.app.dev.ui.service.UssdData
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class MainUssdFragment : BaseFragment(R.layout.fragment_main_ussd) {

    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentMainUssdBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val adapter = MainUssdAdapter()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentMainUssdBinding.bind(view)
        setUpUI()
        collects()

    }


    override fun setUpUI() {
        bn.apply {
            rvUssdCommand.adapter = adapter

            toolbar.setNavigationOnClickListener {
                requireActivity().finish()
            }

            adapter.setOnClickListener {
                val dialog = UssdBottomSheetDialog(UssdData("USSD ЗАПРОС", "проверка баланса", "*111*120#", "Запросить"))
                dialog.show(childFragmentManager, "tag")
            }
        }
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}