package com.mobiuz.app.dev.ui.settings

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.ActivitySettingsBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.global.CONSTANTS
import com.mobiuz.app.dev.utils.LocaleHelper
import com.mobiuz.app.dev.utils.Utils
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class SettingsActivity : AppCompatActivity() {

    private var _bn: ActivitySettingsBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var navController: NavController

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        LocaleHelper.setLocale(this)

        super.onCreate(savedInstanceState)
        _bn = ActivitySettingsBinding.inflate(layoutInflater)
        setContentView(bn.root)
        val window = window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
        val fragment = supportFragmentManager.findFragmentById(R.id.settings_container) as NavHostFragment
        navController = NavHostFragment.findNavController(fragment)

        intent?.let {
            val type = it.getStringExtra(CONSTANTS.TYPE_SETTINGS)
            when (type) {
                CONSTANTS.PROFILE -> {
                    navController.popBackStack()
                    navController.navigate(R.id.profileFragment, null, Utils.navOptions())

                }

                CONSTANTS.SUPPORT -> {
                    navController.popBackStack()
                    navController.navigate(R.id.supportFragment, null, Utils.navOptions())

                }
                CONSTANTS.SAFETY -> {
                    navController.popBackStack()
                    navController.navigate(R.id.safetyFragment, null, Utils.navOptions())

                }
                else -> Unit
            }
        }
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}