package uz.mobiuz.mobiservice.dev.ui.home

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import uz.mobiuz.mobiservice.dev.network.model.Customer
import uz.mobiuz.mobiservice.dev.network.model.Roaming
import uz.mobiuz.mobiservice.dev.network.model.UiStateObject
import uz.mobiuz.mobiservice.dev.network.repository.MainRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class HomeViewModel @Inject constructor(
    private val repository: MainRepository
) : ViewModel() {

    private val _mainIndexUiState = MutableStateFlow<UiStateObject<Customer>>(UiStateObject.EMPTY)
    val mainIndexUiState: StateFlow<UiStateObject<Customer>> = _mainIndexUiState

    fun mainIndex() = viewModelScope.launch {
        _mainIndexUiState.value = UiStateObject.LOADING
        _mainIndexUiState.value = repository.mainIndex()
    }

    private val _mainRoamingUiState = MutableStateFlow<UiStateObject<Roaming>>(UiStateObject.EMPTY)
    val mainRoamingUiState: StateFlow<UiStateObject<Roaming>> = _mainRoamingUiState

    fun mainRoaming() = viewModelScope.launch {
        _mainRoamingUiState.value = UiStateObject.LOADING
        _mainRoamingUiState.value = repository.mainRoaming()
    }


}