package uz.mobiuz.mobiservice.dev.ui.service

import android.Manifest
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import uz.mobiuz.mobiservice.dev.databinding.BottomSheetUssdBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.model.UssdData
import uz.mobiuz.mobiservice.dev.ui.global.ButtonClick
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS
import uz.mobiuz.mobiservice.dev.utils.extensions.checkPermission
import uz.mobiuz.mobiservice.dev.utils.extensions.customLog
import javax.inject.Inject

@AndroidEntryPoint
class UssdBottomSheetDialog(val data: UssdData) : BottomSheetDialogFragment() {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: BottomSheetUssdBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    private var job: Job? = null

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        _bn = BottomSheetUssdBinding.inflate(inflater)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpUI()
    }

    private fun setUpUI() {
        bn.apply {
            data.apply {
                txtTitle.text = this.title.getTranslated()
                val dec = this.short_description.getTranslated()
                txtDescription.isVisible = dec.isNotEmpty()
                txtDescription.text = dec
                txtCode.text = this.code
            }
            btnSent.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    pref.isShowPin = false
                    checkPermission(Manifest.permission.CALL_PHONE) {
                        try {
                            var ussd = ""
                            data.code.forEach {
                                if (it == '#') ussd += Uri.encode("#")
                                else ussd += it
                            }
                            val intent = Intent(Intent.ACTION_CALL, Uri.parse("tel:$ussd"))
                            startActivity(intent)

                        } catch (e: Exception) {
                            pref.isShowPin = false
                        }
                        pref.blockedTime = System.currentTimeMillis() + CONSTANTS.BLOCKED_TIME
                        pref.isShowPin = false
                        dismiss()
                    }
                }
            })
        }
    }


    override fun onStart() {
        customLog("bottom sheet onStart")
        super.onStart()
    }

    override fun onStop() {
        customLog("bottom sheet onStop")
        super.onStop()
    }

    override fun onResume() {
        customLog("bottom sheet onResume")
        super.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()
        _bn = null
    }

}

