package uz.mobiuz.mobiservice.dev.utils.extensions

import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import com.nabinbhandari.android.permissions.PermissionHandler
import com.nabinbhandari.android.permissions.Permissions


fun Fragment.checkPermission(permission: String, granted: () -> Unit) {
    val mContext = context ?: return
    val options = Permissions.Options()
    options.setCreateNewTask(true)
    Permissions.check(
        mContext,
        arrayOf(permission),
        null,
        options,
        object : PermissionHandler() {
            override fun onGranted() {
                granted()
            }
        })
}

fun FragmentActivity.checkPermission(permission: String, granted: () -> Unit) {
    val mContext = this
    val options = Permissions.Options()
    options.setCreateNewTask(true)
    Permissions.check(
        mContext,
        arrayOf(permission),
        null,
        options,
        object : PermissionHandler() {
            override fun onGranted() {
                granted()
            }
        })
}

fun Fragment.checkPermissions(permissions: Array<String>, granted: () -> Unit) {
    val mContext = context ?: return
    val options = Permissions.Options()
    options.setCreateNewTask(true)
    Permissions.check(
        mContext,
        permissions,
        null,
        options,
        object : PermissionHandler() {
            override fun onGranted() {
                granted()
            }
        })
}

fun FragmentActivity.checkPermissions(permissions: Array<String>, granted: () -> Unit) {
    val mContext = this
    val options = Permissions.Options()
    options.setCreateNewTask(true)
    Permissions.check(
        mContext,
        permissions,
        null,
        options,
        object : PermissionHandler() {
            override fun onGranted() {
                granted()
            }
        })
}


