package uz.ssd.mobiuz

import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContentProviderCompat.requireContext
import androidx.lifecycle.LiveData
import androidx.navigation.NavController
import com.google.android.material.bottomnavigation.BottomNavigationView
import dagger.hilt.android.AndroidEntryPoint
import uz.ssd.mobiuz.databinding.ActivityMainBinding
import uz.ssd.mobiuz.model.SharedPref
import uz.ssd.mobiuz.ui.global.FullScreenDialog
import uz.ssd.mobiuz.ui.global.CONSTANTS
import uz.ssd.mobiuz.utils.extensions.customLog
import uz.ssd.mobiuz.utils.extensions.setupWithNavController
import javax.inject.Inject


@AndroidEntryPoint
class MainActivity : AppCompatActivity() {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: ActivityMainBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    private lateinit var bottomNavigationView: BottomNavigationView
    private var currentNavController: LiveData<NavController>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityMainBinding.inflate(layoutInflater)
        setContentView(bn.root)

        window.statusBarColor = Color.TRANSPARENT

        if (savedInstanceState == null) {
            setupBottomNavigationBar()
        }

        intent?.let {
            val arg = it.getStringExtra(CONSTANTS.FIRST) ?: ""
            if (arg.isEmpty()) {
                val dialog = FullScreenDialog()
                dialog.setOnPinDoneListener {
                    pref.setUserToken("")
                    pref.isRegistered = false
                    pref.pin_code = ""
                    val intent = Intent(this, AuthActivity::class.java)
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                    startActivity(intent)
                    finish()
                }
                dialog.show(supportFragmentManager, "tag")
            }
        }
        customLog("token: ${pref.getUserToken()}")
    }

    private fun setupBottomNavigationBar() {
        try {
            bottomNavigationView = findViewById(R.id.bottom_nav_view)
            val navGraphIds = listOf(
                R.navigation.nav_graph_home,
                R.navigation.nav_graph_profile
            )

            val controller = bottomNavigationView.setupWithNavController(
                navGraphIds = navGraphIds,
                fragmentManager = supportFragmentManager,
                containerId = R.id.nav_host_fragment,
                intent = intent
            )
            currentNavController = controller
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    override fun onSupportNavigateUp(): Boolean {
        return currentNavController?.value?.navigateUp() ?: false
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}