package uz.ssd.mobiuz.model

import android.content.Context
import android.content.SharedPreferences
import dagger.hilt.android.qualifiers.ApplicationContext
import javax.inject.Inject

class SharedPref @Inject constructor(@ApplicationContext context: Context) {

    private var mySharedPref: SharedPreferences = context.getSharedPreferences("mvd", Context.MODE_PRIVATE)

    fun setDeviceToken(token: String) {
        mySharedPref.edit().putString("device_token", token).apply()
    }

    fun getDeviceToken(): String? {
        return mySharedPref.getString("device_token", null)
    }

    fun setUserToken(token: String?) {
        mySharedPref.edit().putString("user_token", token).apply()
    }

    fun getUserToken(): String? {
        return mySharedPref.getString("user_token", null)
    }

    var language: String
        get() = mySharedPref.getString(::language.name, "")?:""
        set(value) {
            mySharedPref.edit().putString(::language.name, value).apply()
        }

    var pin_code: String
        get() = mySharedPref.getString(::pin_code.name, "")?:""
        set(value) {
            mySharedPref.edit().putString(::pin_code.name, value).apply()
        }

    var isRegistered: Boolean
        get() = mySharedPref.getBoolean("isRegistered", false)
        set(value) {
            mySharedPref.edit().putBoolean("isRegistered", value).apply()
        }

    var userPhone: String
        get() = mySharedPref.getString(::userPhone.name, "")?:""
        set(value) {
            mySharedPref.edit().putString(::userPhone.name, value).apply()
        }

}