package uz.ssd.mobiuz.ui.global

import android.graphics.Color
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.DialogFragment
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.databinding.LayoutSenderBinding
import uz.ssd.mobiuz.utils.extensions.SingleBlock

class SenderDialog(
    private val txtDescription: String,
    private val status: Boolean
) : DialogFragment() {

    private var listener: SingleBlock<Unit>? = null
    private var _bn: LayoutSenderBinding? = null
    private val bn get() = _bn!!

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NO_TITLE, R.style.CustomDialog)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _bn = LayoutSenderBinding.inflate(inflater, container, false)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        isCancelable = false
        bn.apply {
            if (!status) {
                title.text = getString(R.string.error_data)
                description.setTextColor(Color.RED)
                title.setTextColor(Color.RED)
                lottie.setAnimation(R.raw.error_lottie)
            }
            description.text = txtDescription
            btnOk.setOnClickListener {
                listener?.invoke(Unit)
                dismiss()
            }
        }
    }

    fun setOnClickListener(block: SingleBlock<Unit>) {
        listener = block
    }

    override fun onDestroy() {
        super.onDestroy()
        _bn = null
    }
}
