package uz.mobiuz.mobiservice.dev.ui.home

import android.os.Bundle
import android.view.View
import androidx.core.os.bundleOf
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.FragmentBillingBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.ui.base.BaseFragment
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS
import uz.mobiuz.mobiservice.dev.utils.extensions.showMessage
import javax.inject.Inject

@AndroidEntryPoint
class BillingFragment : BaseFragment(R.layout.fragment_billing) {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: FragmentBillingBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController by lazy (LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentBillingBinding.bind(view)
        setUpUI()
        val window = requireActivity().window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
    }


     override fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
               navController.navigateUp()
            }

            savedCards.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
//                        pref.isShowPin = false
                        navController.navigate(R.id.cardsListFragment, bundleOf(CONSTANTS.PHONE to pref.userPhone.filter { it.isDigit() }))
//                        startActivity(
//                            AGRBilling.createCardsListIntent(requireContext(), pref.userPhone.filter { it.isDigit() })
//                        )
                    }
                })
            }
            /*payments.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(AGRBilling.createReplenishBalanceIntent(requireContext(), phoneNumber))
                    }
                })
            }
            monitoring.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(AGRBilling.createHistoryIntent(requireContext(), phoneNumber))
                    }
                })
            }*/
        }
    }

    override fun collects() {}

    private fun getPhoneNumber(listener: LoadPhoneNumber) {
        val number = pref.userPhone.filter { it.isDigit() }
        if (number.length == 12) {
            listener.invoke(number)
        } else {
            showMessage("Invalid phone number")
        }
    }

    private interface LoadPhoneNumber {
        fun invoke(phoneNumber: String)
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}