package uz.mobiuz.mobiservice.dev.ui.sdk.card

import android.os.Bundle
import android.view.View
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.FragmentCardConfirmBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.network.model.UiStateObject
import uz.mobiuz.mobiservice.dev.ui.base.BaseFragment
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS
import uz.mobiuz.mobiservice.dev.ui.home.HomeViewModel
import javax.inject.Inject

@AndroidEntryPoint
class CardConfirmFragment : BaseFragment(R.layout.fragment_card_confirm) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentCardConfirmBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val viewModel: HomeViewModel by viewModels()
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    private var cardId = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            cardId = it.getString(CONSTANTS.CARD_ID) ?: ""
        }
    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentCardConfirmBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {


    }


    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.mainIndexUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {


                    }
                    is UiStateObject.ERROR -> {


                    }
                    is UiStateObject.LOADING -> {


                    }
                    else -> Unit
                }
            }
        }


    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}