package com.mobiuz.app.dev.ui.global

import android.Manifest
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.mobiuz.app.databinding.BottomSheetUssdBinding
import com.mobiuz.app.databinding.LayoutOfflineBottomSheetBinding
import com.mobiuz.app.dev.OfflineActivity
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.model.UssdData
import com.mobiuz.app.dev.utils.extensions.checkPermission
import com.mobiuz.app.dev.utils.extensions.getCurrentName
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class OfflineBottomSheet() : BottomSheetDialogFragment() {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: LayoutOfflineBottomSheetBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private var lng = ""

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        _bn = LayoutOfflineBottomSheetBinding.inflate(inflater)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpUI()
    }

    private fun setUpUI() {
        bn.apply {
            lng = pref.language
            btnZapros.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    pref.isShowPin = false
                    navigate()
                }
            })

            btnOtmena.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                   dismiss()
                }
            })
        }
    }
    fun navigate(){
        val intent = Intent(requireContext(), OfflineActivity::class.java)
        intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
        startActivity(intent)
        requireActivity().finishAffinity()
        dismiss()
    }

    override fun onDestroy() {
        super.onDestroy()
        _bn = null
    }

}