package com.mobiuz.app.dev.ui.service.packets


import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.tabs.TabLayoutMediator
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentPaketsBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.service.FragmentPagerAdapter
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class PacketsFragment : BaseFragment(R.layout.fragment_pakets) {

    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentPaketsBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var adapter : FragmentPagerAdapter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentPaketsBinding.bind(view)
        adapter = FragmentPagerAdapter(this, arrayListOf("","","","",""))
        setUpUI()
        collects()

    }


    override fun setUpUI() {
        bn.apply {
            viewPager.adapter = adapter

            toolbar.setNavigationOnClickListener {
                requireActivity().finish()
            }
            TabLayoutMediator(bn.tabLayout,bn.viewPager){tab,pos->

                when(pos){
                    0 -> tab.text = "Месячные "
                    1 -> tab.text = "Суточные "
                    2 -> tab.text = "Ночные "
                    3 -> tab.text = "Ночной Драйв "
                    else -> tab.text = "OnNet "
                }

            }.attach()
        }
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}