package com.mobiuz.app.dev.ui.service.tarifes

import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.tabs.TabLayoutMediator
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentTarifsBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.service.FragmentPagerAdapter
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class TariffsFragment : BaseFragment(R.layout.fragment_tarifs) {

    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentTarifsBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var adapter : FragmentPagerAdapter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentTarifsBinding.bind(view)
        adapter = FragmentPagerAdapter(this, arrayListOf("",""))
        setUpUI()
        collects()

    }


    override fun setUpUI() {
        bn.apply {
            viewPager.adapter = adapter

            toolbar.setNavigationOnClickListener {
                requireActivity().finish()
            }
            TabLayoutMediator(bn.tabLayout,bn.viewPager){tab,pos->
                if(pos == 0){
                    tab.text = "Активные"
                }else{
                    tab.text = "Годовые"
                }
            }.attach()
        }
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}