package com.mobiuz.app.dev.network.repository

import android.content.Context
import com.google.gson.Gson
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.model.UserAuth
import com.mobiuz.app.dev.network.api.ApiService
import com.mobiuz.app.dev.network.model.ChangePassword
import com.mobiuz.app.dev.network.model.Customer
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.utils.extensions.getMessage
import com.mobiuz.app.dev.utils.extensions.userMessage
import dagger.hilt.android.qualifiers.ApplicationContext
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class MainRepository @Inject constructor(
    private val apiService: ApiService,
    private val pref: SharedPref,
    @ApplicationContext val context: Context
){
    suspend fun mainIndex(): UiStateObject<Customer> {
        return try {
            val res = apiService.mainIndex()

            when {
                res.status && res.data != null -> {
                    UiStateObject.SUCCESS(res.data!!)
                }
                res.errors.isNotEmpty() -> UiStateObject.ERROR(res.errors.getMessage())
                else -> UiStateObject.ERROR(res.message)
            }
        } catch (e: Exception) {
            UiStateObject.ERROR(e.userMessage(context))
        }
    }

    suspend fun logOut(): UiStateObject<String> {
        return try {
            val res = apiService.logOut()

            when {
                res.status -> {
                    UiStateObject.SUCCESS(res.message)
                }
                res.errors.isNotEmpty() -> UiStateObject.ERROR(res.errors.getMessage())
                else -> UiStateObject.ERROR(res.message)
            }
        } catch (e: Exception) {
            UiStateObject.ERROR(e.userMessage(context))
        }
    }

    suspend fun services(): UiStateObject<String> {
        return try {
            val res = apiService.getServices()

            when {
                res.status -> {
                    pref.services = Gson().toJson(res.data)
                    UiStateObject.SUCCESS(res.message)
                }
                res.errors.isNotEmpty() -> UiStateObject.ERROR(res.errors.getMessage())
                else -> UiStateObject.ERROR(res.message)
            }
        } catch (e: Exception) {
            UiStateObject.ERROR(e.userMessage(context))
        }
    }


}