package uz.mobiuz.mobiservice.dev.di

import android.content.Context
import androidx.room.Room
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import uz.mobiuz.mobiservice.dev.model.database.MonitoringDao
import uz.mobiuz.mobiservice.dev.model.database.RoomDatabase
import javax.inject.Singleton


@Module
@InstallIn(SingletonComponent::class)
class DatabaseModule {

    @Provides
    @Singleton
    fun getDatabase(@ApplicationContext context: Context): RoomDatabase =
        Room.databaseBuilder(context, RoomDatabase::class.java,"block").build()

    @Provides
    @Singleton
    fun getProductDao(database: RoomDatabase): MonitoringDao = database.monitoringDao()
}

