package uz.mobiuz.mobiservice.dev.ui.global

object CONSTANTS {

    const val CARD_ID = "CARD_ID"
    const val TRANSACTION_ID = "TRANSACTION_ID"
    const val SAVED_CARD = "SAVED_CARD"
    const val CARD_NUMBER = "CARD_NUMBER"
    const val CARD_EXPIRE = "CARD_EXPIRE"
    const val UNAUTHORIZED = "UNAUTHORIZED"
    const val BASE_URL = "https://mobileapp.mobi.uz/api/v1/"

    //languages
    const val RU = "ru"
    const val UZ = "uz"
    const val EN = "en"

    // safety data
    const val HELP_BOT = "@MobiuzHelpBot"
    const val HTTP_MOBI_UZ = "https://mobi.uz"
    const val WWW_MOBI_UZ = "www.mobi.uz"
    const val MOBI_UZ_SELF_CARE = "https://ip.mobi.uz/selfcare/"
    const val FEEDBACK = "https://company.mobi.uz/ru/feedback/"
    const val TERMS_OF_USE = "Terms of Use"
    const val PRIVACY_POLICY = "Privacy Policy"

    const val LICENSE_UZ = "https://mobileapp.mobi.uz/uploads/licenses/license_uz.html"
    const val LICENSE_RU = "https://mobileapp.mobi.uz/uploads/licenses/license_ru.html"
    const val LICENSE_EN = "https://mobileapp.mobi.uz/uploads/licenses/license_en.html"

    const val PRIVACY_POLICY_UZ = "https://mobileapp.mobi.uz/uploads/privacy/privacy_policy_uz.html"
    const val PRIVACY_POLICY_RU = "https://mobileapp.mobi.uz/uploads/privacy/privacy_policy_ru.html"
    const val PRIVACY_POLICY_EN = "https://mobileapp.mobi.uz/uploads/privacy/privacy_policy_en.html"

    const val PAYSYS_LICENSE_UZ = "https://mobileapp.mobi.uz/uploads/paysys/license_uz.html"
    const val PAYSYS_LICENSE_RU = "https://mobileapp.mobi.uz/uploads/paysys/license_ru.html"
    const val PAYSYS_LICENSE_EN = "https://mobileapp.mobi.uz/uploads/paysys/license_en.html"

    const val PHONE1 = "0890"
    const val PHONE2 = "+998 97 130 09 09"
    const val PHONE3 = "+998 97 203 10 10"
    const val DEFAULT_PHONE = "+998 97 999-99-99"
    const val RESEND_CODE_TIME = 60000L
    const val BLOCKED_TIME = 6000


    const val PHONE = "phone"
    const val TYPE_AUTH = "type_auth"
    const val LOGIN = "login"
    const val REGISTER = "register"
    const val TYPE_VERIFICATION = "type_verification"
    const val TYPE_FORGET = "type_forget"
    const val TYPE_ADD_CARD = "TYPE_ADD_CARD"
    const val TYPE_ANOTHER_CARD = "TYPE_ANOTHER_CARD"
    const val PIN_CODE = "PIN_CODE"
    const val FIRST = "first"
    const val SERVICE = "service"
    const val TYPE_SERVICE = "type_service"
    const val OFFLINE = "offline"
    const val FROM_ONLINE = "FROM_ONLINE"
    const val FULL_SCREEN_DIALOG = "full_screen_dialog"
    const val CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE"
    const val INTENT_ACTION_NAVIGATE = "INTENT_ACTION_NAVIGATE"
    const val MY_CONNECTIVITY_CHANGE = "MY_CONNECTIVITY_CHANGE"
    const val FRAGMENT_ID = "FRAGMENT_ID"


    //password types
    const val TYPE_PASSWORD = "TYPE_PASSWORD"
    const val OLD_PASSWORD = "OLD_PASSWORD"
    const val LATEST_PASSWORD = "LATEST_PASSWORD"
    const val CURRENT_PASSWORD = "CURRENT_PASSWORD"
    const val NEW_PASSWORD = "NEW_PASSWORD"
    const val CONFIRM_NEW_PASSWORD = "CONFIRM_NEW_PASSWORD"


    //pin types
    const val TYPE_PIN = "TYPE_PIN"
    const val TYPE_AFTER = "TYPE_AFTER"
    const val NEW_PIN = "NEW_PIN"
    const val CONFIRM_NEW_PIN = "CONFIRM_NEW_PIN"
    const val CURRENT_PIN = "CURRENT_PIN"
    const val CHANGE_NEW_PIN = "CHANGE_NEW_PIN"
    const val CONFIRM_CHANGE_NEW_PIN = "CONFIRM_CHANGE_NEW_PIN"



    //urls
    const val API_LOGIN = "customer/login"
    const val API_REGISTER = "customer/register"
    const val API_CHECK_PHONE = "customer/check-phone"
    const val API_CHECK_SMS_CODE = "customer/check-sms-code"
    const val API_MAIN_INDEX = "main/index"
    const val API_FORGET_PASSWORD = "customer/forget-password"
    const val API_CHECK_RESET_CODE = "customer/check-reset-code"
    const val API_RESET_PASSWORD = "customer/reset-password"
    const val API_LOG_OUT = "customer/log-out"
    const val API_SEND_SMS_CODE = "customer/send-sms-code"
    const val API_CHECK_PASSWORD = "customer/check-password"
    const val API_CHANGE_PASSWORD = "customer/change-password"
    const val API_SERVICE_INDEX = "service/index"
    const val API_MAIN_ROAMING = "main/roaming"


    //payment
    const val PAY_MIN_AMOUNT = 1000
    const val PAY_MAX_AMOUNT = 500_000L
    const val PAY_AMOUNT = "PAYMENT_SUCCESS_PAYMENT"
    const val PAY_SAVE_CARD = "PAYMENT_SAVE_CARD"
    const val PAY_CARD_NUMBER = "PAYMENT_CARD_NUMBER"
}
