package com.mobiuz.app.dev.network.api

import com.mobiuz.app.dev.model.ServiceData
import com.mobiuz.app.dev.model.UserAuth
import com.mobiuz.app.dev.network.model.*
import com.mobiuz.app.dev.ui.global.CONSTANTS
import retrofit2.http.Body
import retrofit2.http.POST


interface ApiService {

    @POST(CONSTANTS.API_LOGIN)
    suspend fun login(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST(CONSTANTS.API_REGISTER)
    suspend fun register(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST(CONSTANTS.API_CHECK_PHONE)
    suspend fun checkPhone(
        @Body req: UserAuth
    ): ResponseObject<Action>

    @POST(CONSTANTS.API_CHECK_SMS_CODE)
    suspend fun checkSMSCode(
        @Body req: UserAuth
    ): ResponseObject<GenerateToken>

    @POST(CONSTANTS.API_MAIN_INDEX)
    suspend fun mainIndex(): ResponseObject<Customer>

    @POST(CONSTANTS.API_FORGET_PASSWORD)
    suspend fun forgetPassword(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST(CONSTANTS.API_CHECK_RESET_CODE)
    suspend fun checkResetCode(
        @Body req: UserAuth
    ): Response

    @POST(CONSTANTS.API_RESET_PASSWORD)
    suspend fun resetPassword(
        @Body req: UserAuth
    ): ResponseObject<GenerateToken>

    @POST(CONSTANTS.API_LOG_OUT)
    suspend fun logOut(): Response

    @POST(CONSTANTS.API_SEND_SMS_CODE)
    suspend fun reSendSms(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST(CONSTANTS.API_CHECK_PASSWORD)
    suspend fun checkPassword(
        @Body req: UserAuth
    ): Response

    @POST(CONSTANTS.API_CHANGE_PASSWORD)
    suspend fun installPassword(
        @Body req: ChangePassword
    ): Response

    @POST(CONSTANTS.API_SERVICE_INDEX)
    suspend fun getServices(): ResponseList<ServiceData>


}