package uz.ssd.mobiuz

import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.view.View
import android.view.WindowManager
import androidx.appcompat.app.AppCompatActivity
import dagger.hilt.android.AndroidEntryPoint
import uz.ssd.mobiuz.databinding.ActivityLanguageBinding
import uz.ssd.mobiuz.model.SharedPref
import uz.ssd.mobiuz.utils.CONSTANTS
import javax.inject.Inject

@AndroidEntryPoint
class LanguageActivity : AppCompatActivity() {

    private var _bn: ActivityLanguageBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityLanguageBinding.inflate(layoutInflater)
        setContentView(bn.root)
        window.decorView.systemUiVisibility = window.decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR

//        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS)
//        window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS)

//        window.setTitleColor(Color.BLACK)

        bn.apply {
            uzbekLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.UZ)
            }
            russianLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.RU)
            }
            englishLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.EN)
            }
        }
    }

    private fun setLangAndNavigate(lang: String) {
        pref.language = lang
        startActivity(Intent(this@LanguageActivity, AuthActivity::class.java))
        finish()
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}