package uz.ssd.mobiuz.ui.auth

import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.view.View
import androidx.core.view.isVisible
import androidx.fragment.app.Fragment
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import uz.ssd.mobiuz.MainActivity
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.databinding.FragmentVerificationBinding
import uz.ssd.mobiuz.model.UserAuth
import uz.ssd.mobiuz.network.model.UiStateObject
import uz.ssd.mobiuz.ui.base.BaseFragment
import uz.ssd.mobiuz.ui.global.TextWatcherWrapper
import uz.ssd.mobiuz.utils.ButtonClick
import uz.ssd.mobiuz.utils.Utils
import uz.ssd.mobiuz.utils.extensions.showMessage
import java.lang.NullPointerException

@AndroidEntryPoint
class VerificationFragment : BaseFragment(R.layout.fragment_verification) {

    private var _bn: FragmentVerificationBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val viewModel : AuthViewModel by viewModels()
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentVerificationBinding.bind(view)
        setUpUI()
        count(true)
        collects()
    }

    override fun setUpUI() {
        bn.apply {

            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }

            pinView.addTextChangedListener(object : TextWatcherWrapper(){
                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                    super.onTextChanged(s, start, before, count)
                    btnLogin.isEnabled = s.toString().length > 5
                }
            })

            btnLogin.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    viewModel.login(UserAuth("phone", "password"))
                }
            })

            countWaitText.setTextColor(Color.parseColor("#97ADB6"))

            sentCodeAgain.setTextColor(Color.parseColor("#FF9500"))

            sentCodeAgain.setOnClickListener {
                viewModel.login(UserAuth("",""))
                count(true)
            }
            coutdownView.setOnCountdownEndListener {
                count(false)
            }
        }
    }

    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.loginUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {
                        showProgressDialog(false)
                        requireActivity().finish()
                        startActivity(Intent(requireContext(),MainActivity::class.java))
                    }
                    is UiStateObject.ERROR -> {
                        showProgressDialog(false)
                        showMessage(it.message)
                    }
                    is UiStateObject.LOADING -> {
                        showProgressDialog(true)
                    }
                    else -> Unit
                }
            }
        }
    }

    fun count(status: Boolean) {
        bn.apply {
            sentCodeAgain.isVisible = !status
            countWaitText.isVisible = status
            coutdownView.isVisible = status
            if (status) coutdownView.start(120000)
        }
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }

}
