package uz.mobiuz.mobiservice.dev.model.database

import androidx.room.*
import kotlinx.coroutines.flow.Flow
import uz.mobiuz.mobiservice.dev.model.Monitoring

/**
 * Created by DostonbekIbragimov on 21/12/2021.
 */
@Dao
interface MonitoringDao {

    @Query("SELECT * FROM monitoring")
    fun getAllMonitoring(): Flow<List<Monitoring>>

    @Query("DELETE FROM monitoring")
    fun deleteAllMonitoring()

    @Query("SELECT * FROM monitoring WHERE id =:id")
    fun getCardById(id: String): Monitoring?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun addMonitoring(cardInfo: Monitoring): Long

    @Update
    fun updateMonitoring(monitoring: List<Monitoring>)

    @Update
    fun updateMonitoring(monitoringInfo: Monitoring)

    @Delete
    fun deleteMonitoring(monitoringInfo: Monitoring)
}