package uz.mobiuz.mobiservice.dev.ui.auth

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import uz.mobiuz.mobiservice.dev.model.UserAuth
import uz.mobiuz.mobiservice.dev.network.model.Action
import uz.mobiuz.mobiservice.dev.network.model.ChangePassword
import uz.mobiuz.mobiservice.dev.network.model.UiStateObject
import uz.mobiuz.mobiservice.dev.network.repository.AuthRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.launch
import uz.agr.sdk.core.entity.card.CardInfo
import uz.agr.sdk.core.entity.card.CardRegistration
import uz.agr.sdk.pgw_core.VendorPaySuccessListener
import uz.agr.sdk.pgw_core.VendorReSendCodeListener
import uz.agr.sdk.pgw_core.mobi.BaseListener
import uz.agr.sdk.pgw_core.mobi.MobiUz
import javax.inject.Inject

@HiltViewModel
class AuthViewModel @Inject constructor(
    private val repository: AuthRepository
) : ViewModel() {

    private val _checkPhoneUiState = MutableSharedFlow<UiStateObject<Action>>()
    val checkPhoneUiState: SharedFlow<UiStateObject<Action>> = _checkPhoneUiState

    fun checkPhone(data: UserAuth) = viewModelScope.launch {
        _checkPhoneUiState.emit(UiStateObject.LOADING)
        _checkPhoneUiState.emit(repository.checkPhone(data))
    }

    private val _registerUiState = MutableSharedFlow<UiStateObject<String>>()
    val registerUiState: SharedFlow<UiStateObject<String>> = _registerUiState

    fun register(data: UserAuth) = viewModelScope.launch {
        _registerUiState.emit(UiStateObject.LOADING)
        _registerUiState.emit(repository.registerUser(data))
    }

    private val _verificationUiState = MutableSharedFlow<UiStateObject<String>>()
    val verificationUiState: SharedFlow<UiStateObject<String>> = _verificationUiState

    fun verification(data: UserAuth) = viewModelScope.launch {
        _verificationUiState.emit(UiStateObject.LOADING)
        _verificationUiState.emit(repository.checkSMSCode(data))
    }

    private val _loginUiState = MutableSharedFlow<UiStateObject<String>>()
    val loginUiState: SharedFlow<UiStateObject<String>> = _loginUiState

    fun login(data: UserAuth) = viewModelScope.launch {
        _loginUiState.emit(UiStateObject.LOADING)
        _loginUiState.emit(repository.loginUser(data))
    }

    private val _forgetPasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val forgetPasswordUiState: SharedFlow<UiStateObject<String>> = _forgetPasswordUiState

    fun forgetPassword(data: UserAuth) = viewModelScope.launch {
        _forgetPasswordUiState.emit(UiStateObject.LOADING)
        _forgetPasswordUiState.emit(repository.forgetPassword(data))
    }

    private val _checkResetCodeUiState = MutableSharedFlow<UiStateObject<String>>()
    val checkResetCodeUiState: SharedFlow<UiStateObject<String>> = _checkResetCodeUiState

    fun checkResetCode(data: UserAuth) = viewModelScope.launch {
        _checkResetCodeUiState.emit(UiStateObject.LOADING)
        _checkResetCodeUiState.emit(repository.checkResetCode(data))
    }

    private val _resetPasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val resetPasswordUiState: SharedFlow<UiStateObject<String>> = _resetPasswordUiState

    fun resetPassword(data: UserAuth) = viewModelScope.launch {
        _resetPasswordUiState.emit(UiStateObject.LOADING)
        _resetPasswordUiState.emit(repository.resetPassword(data))
    }

    private val _resetSmsCodeUiState = MutableSharedFlow<UiStateObject<String>>()
    val resetSmsCodeUiState: SharedFlow<UiStateObject<String>> = _resetSmsCodeUiState

    fun resetSmsCode(data: UserAuth) = viewModelScope.launch {
        _resetSmsCodeUiState.emit(UiStateObject.LOADING)
        _resetSmsCodeUiState.emit(repository.resetSmsCode(data))
    }

    private val _checkPasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val checkPasswordUiState: SharedFlow<UiStateObject<String>> = _checkPasswordUiState

    fun checkPassword(data: UserAuth) = viewModelScope.launch {
        _checkPasswordUiState.emit(UiStateObject.LOADING)
        _checkPasswordUiState.emit(repository.checkPassword(data))
    }

    private val _changePasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val changePasswordUiState: SharedFlow<UiStateObject<String>> = _changePasswordUiState

    fun changePassword(data: ChangePassword) = viewModelScope.launch {
        _changePasswordUiState.emit(UiStateObject.LOADING)
        _changePasswordUiState.emit(repository.installPassword(data))
    }


    private val _cardConfirmUiState = MutableSharedFlow<UiStateObject<CardInfo>>()
    val cardConfirmUiState: SharedFlow<UiStateObject<CardInfo>> = _cardConfirmUiState

    fun cardConfirm(cardId: String, code: String) = viewModelScope.launch {
        _cardConfirmUiState.emit(UiStateObject.LOADING)
        MobiUz.cardConfirmSms(cardId, code, object : BaseListener<CardInfo> {
            override fun error(message: String) {
                viewModelScope.launch {
                    _cardConfirmUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun loading(boolean: Boolean) {}

            override fun success(data: CardInfo) {
                viewModelScope.launch {
                    _cardConfirmUiState.emit(UiStateObject.SUCCESS(data))
                }
            }
        })
    }

    private val _resendSmsUiState = MutableSharedFlow<UiStateObject<CardRegistration>>()
    val resendSmsUiState: SharedFlow<UiStateObject<CardRegistration>> = _resendSmsUiState

    fun resendSms(phoneNumber: String, cardNumber: String, cardExpire: String) = viewModelScope.launch {
        _resendSmsUiState.emit(UiStateObject.LOADING)
        MobiUz.registerCardResendSms(phoneNumber, cardNumber, cardExpire,object : BaseListener<CardRegistration> {
            override fun error(message: String) {
                viewModelScope.launch {
                    _resendSmsUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun loading(boolean: Boolean) {}

            override fun success(data: CardRegistration) {
                viewModelScope.launch {
                    _resendSmsUiState.emit(UiStateObject.SUCCESS(data))
                }
            }
        })
    }

    private val _vendorResendSmsUiState = MutableSharedFlow<UiStateObject<Int>>()
    val vendorResendSmsUiState: SharedFlow<UiStateObject<Int>> = _vendorResendSmsUiState

    fun vendorResendSms(transactionId: Long) = viewModelScope.launch {
        _vendorResendSmsUiState.emit(UiStateObject.LOADING)
        MobiUz.vendorReSendSmsCode(transactionId, object : VendorReSendCodeListener {

            override fun showError(message: String) {
                viewModelScope.launch {
                    _vendorResendSmsUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun showProgress(show: Boolean) {}

            override fun showTimer(result: Int) {
                viewModelScope.launch {
                    _vendorResendSmsUiState.emit(UiStateObject.SUCCESS(result))
                }
            }
        })
    }



    private val _vendorUiState = MutableSharedFlow<UiStateObject<String>>()
    val vendorUiState: SharedFlow<UiStateObject<String>> = _vendorUiState

    fun vendor(code: String, transactionId: Long) = viewModelScope.launch {
        _vendorUiState.emit(UiStateObject.LOADING)
        MobiUz.vendorPay(code, transactionId, object : VendorPaySuccessListener {
            override fun exit() {
                viewModelScope.launch {
                    _vendorUiState.emit(UiStateObject.ERROR("exit"))
                }
// exit
            }

            override fun showError(message: String) {
                viewModelScope.launch {
                    _vendorUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun showProgress(show: Boolean) {
                show
            }

            override fun showSuccess(transactionId: String) {
                transactionId
                viewModelScope.launch {
                    _vendorUiState.emit(UiStateObject.SUCCESS(transactionId))
                }
            }
        })
    }


}