package uz.mobiuz.mobiservice.dev.ui.sdk.history

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.launch
import uz.mobiuz.mobiservice.dev.model.Monitoring
import uz.mobiuz.mobiservice.dev.network.repository.CardRepository
import javax.inject.Inject

@HiltViewModel
class HistoryViewModel @Inject constructor(
    private val repository: CardRepository
) : ViewModel() {

    fun addMonitoring(data: Monitoring) = viewModelScope.launch {
        repository.addMonitoring(data)
    }


    fun getAllMonitoring() = repository.getAllMonitoring()

}