package com.mobiuz.app

import android.os.Bundle
import android.view.View
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.databinding.FragmentBillingBinding
import com.mobiuz.app.dev.model.PinData
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.auth.pin.PinAdapter
import com.mobiuz.app.dev.ui.base.BaseFragment
import dagger.hilt.android.AndroidEntryPoint
import uz.agr.mobiuz.AGRBilling
import uz.agr.sdk.coreui.extension.showSnackMessage
import javax.inject.Inject

@AndroidEntryPoint
class BillingFragment : BaseFragment(R.layout.fragment_billing) {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: FragmentBillingBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    private val data = ArrayList<PinData>()
    private val pinAdapter = PinAdapter()
    private var count = 3
    private lateinit var decorView: View


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentBillingBinding.bind(view)

        count = 3
        setUpUI()
        collects()
    }

    override fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }

            AGRBilling.hasCards().subscribe({
                showSnackMessage("Has Cards")
            }, {
                showSnackMessage("No Card")
            }).dispose()

            savedCards.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(
                            AGRBilling.createCardsListIntent(requireContext(), "998990552109")
                        )
                    }
                })
            }
            payments.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        /*
                        Vendor(
                100082, "OOO UMS", "UMS", "https://agr.uz/application/resources/img/ums.jpg"
            )
                         */
                        startActivity(
                            AGRBilling.createReplenishBalanceIntent(requireContext(), phoneNumber)
                        )
                    }
                })
            }
            monitoring.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(
                            AGRBilling.createHistoryIntent(requireContext(), phoneNumber)
                        )
                    }
                })
            }
        }
    }


    override fun collects() {

    }

    private fun getPhoneNumber(listener: LoadPhoneNumber) {
        val number = "998990552109"
        if (number.length == 12) {
            listener.invoke(number)
        } else {
            showSnackMessage("Invalid phone number")
        }
    }

    private interface LoadPhoneNumber {
        fun invoke(phoneNumber: String)
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}