package uz.mobiuz.mobiservice.dev.ui.service

import android.Manifest
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import uz.mobiuz.mobiservice.dev.databinding.BottomSheetUssdBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.model.UssdData
import uz.mobiuz.mobiservice.dev.ui.global.ButtonClick
import uz.mobiuz.mobiservice.dev.utils.extensions.checkPermission
import uz.mobiuz.mobiservice.dev.utils.extensions.getCurrentName
import dagger.hilt.android.AndroidEntryPoint
import uz.mobiuz.mobiservice.dev.utils.extensions.customLog
import javax.inject.Inject

@AndroidEntryPoint
class UssdBottomSheetDialog(val data: UssdData) : BottomSheetDialogFragment() {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: BottomSheetUssdBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private var lng = ""

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        _bn = BottomSheetUssdBinding.inflate(inflater)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpUI()
    }

    private fun setUpUI() {
        bn.apply {
            lng = pref.language
            data.apply {
                txtTitle.text = this.title.getCurrentName(lng)
                val dec = this.short_description.getCurrentName(lng)
                txtDescription.isVisible = dec.isNotEmpty()
                txtDescription.text = dec
                txtCode.text = this.code
            }
            btnSent.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    pref.isShowPin = false
                    checkPermission(Manifest.permission.CALL_PHONE) {
                        try {
                            pref.blockedTime = System.currentTimeMillis()
                            pref.isShowPin = false
                            var ussd = ""
                            data.code.forEach {
                                if (it == '#') ussd += Uri.encode("#")
                                else ussd += it
                            }
                            val intent = Intent(Intent.ACTION_CALL, Uri.parse("tel:$ussd"))
                            startActivityForResult(intent, 100)

                        } catch (e: Exception) {
                            pref.isShowPin = false
                        }
                        dismiss()
                    }
                }
            })
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        customLog("onActivityResult requestCode:$requestCode")
    }

    override fun onStart() {
        customLog("bottom sheet onStart")
        super.onStart()
    }

    override fun onStop() {
        customLog("bottom sheet onStop")
        super.onStop()
    }

    override fun onResume() {
        customLog("bottom sheet onResume")
        super.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()
        _bn = null
    }

}

