package com.mobiuz.app.dev.network.repository

import android.content.Context
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.network.api.ApiService
import com.mobiuz.app.dev.network.model.Customer
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.utils.extensions.userMessage
import dagger.hilt.android.qualifiers.ApplicationContext
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class MainRepository @Inject constructor(
    private val apiService: ApiService,
    private val pref: SharedPref,
    @ApplicationContext val context: Context
){
    suspend fun mainIndex(): UiStateObject<Customer> {
        return try {
            val res = apiService.mainIndex()

            when {
                res.status && res.data != null -> {
                    UiStateObject.SUCCESS(res.data!!)
                }
                res.errors.isNotEmpty() -> {
                    var message = ""
                    res.errors.forEach {
                        message += "${it.message}\n"
                    }
                    UiStateObject.ERROR(message)
                }
                else -> UiStateObject.ERROR(res.message)
            }
        } catch (e: Exception) {
            UiStateObject.ERROR(e.userMessage(context))
        }
    }
}