package com.mobiuz.app.dev.ui.home

import android.annotation.SuppressLint
import android.graphics.Color
import android.os.Bundle
import android.view.View
import androidx.core.view.isVisible
import androidx.core.widget.NestedScrollView
import androidx.fragment.app.viewModels
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.lifecycleScope
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentHomeBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.network.model.Customer
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.utils.extensions.customLog
import com.mobiuz.app.dev.utils.extensions.getColorCompat
import com.mobiuz.app.dev.utils.extensions.toMoneyFormat
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import javax.inject.Inject


@AndroidEntryPoint
class HomeFragment : BaseFragment(R.layout.fragment_home) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentHomeBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val viewModel: HomeViewModel by viewModels()
    private lateinit var mainViewModel: MainViewModel

    private var customer: Customer? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
//        viewModel.mainIndex()
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentHomeBinding.bind(view)
        val window = requireActivity().window.decorView
        window.systemUiVisibility = View.VISIBLE
        setUpUI()
        collects()

    }

    override fun setUpUI() {

        bn.apply {
            toolbar.setNavigationOnClickListener {
                mainViewModel.mainIndex(System.currentTimeMillis())
            }

            nestedScrollView.setOnScrollChangeListener(
                NestedScrollView.OnScrollChangeListener { v, scrollX, scrollY, oldScrollX, oldScrollY ->

                    if (scrollY > 120) {
                        toolbarInsideLayout.isVisible = true
                        topDiv.setBackgroundColor(getColorCompat(R.color.primary100))
                        toolbar.setBackgroundColor(getColorCompat(R.color.primary100))
                    }

                    if (scrollY < 100) {
                        toolbarInsideLayout.isVisible = false
                        topDiv.setBackgroundColor(Color.TRANSPARENT)
                        toolbar.setBackgroundColor(Color.TRANSPARENT)
                    }
                })
        }
    }

    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.mainIndexUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {
                        showProgressDialog(false)
                        customer = it.data
                        loadData()
                    }
                    is UiStateObject.ERROR -> {
                        showProgressDialog(false)
//                        showCustomDialog(it.message,false){}
                    }
                    is UiStateObject.LOADING -> {
                        showProgressDialog(true)
                    }
                    else -> Unit
                }
            }
        }
    }

    @SuppressLint("SetTextI18n")
    private fun loadData() {
        try {
            customLog("customer:$customer")
            customer?.customer?.info?.let {
                bn.apply {
                    txtBalance.text = "${it.balance?.amount?.toMoneyFormat()} ${it.balance?.currency}"
                    it.counters.let {
                        txtCountMb.text = it?.BYTE?.value?.toMoneyFormat() ?: "0"
                        txtTypeMb.text = it?.BYTE?.unit ?: "mb"

                        txtCountMinut.text = it?.SECOND?.value?.toMoneyFormat() ?: "0"
                        txtTypeMinut.text = it?.SECOND?.unit ?: "min"

                        txtCountSms.text = it?.ITEM?.value?.toMoneyFormat() ?: "0"
                        txtTypeSms.text = it?.ITEM?.unit ?: "sms"
                    }
                    mainViewModel.setUserName(customer?.customer?.name ?: "Unnamed User")
                    txtTarif.text = customer?.customer?.tarifi?.name ?: getString(R.string.my_tarif)
                    txtMyNumber.text = pref.userPhone
                    toolbarMyNumber.text = pref.userPhone
                }
            }
        } catch (e: Exception) {
//            showSnackMessage(it.message)
        }


    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}