package com.mobiuz.app

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import dagger.hilt.android.AndroidEntryPoint
import com.mobiuz.app.databinding.ActivityLanguageBinding
import com.mobiuz.app.model.SharedPref
import com.mobiuz.app.ui.global.CONSTANTS
import javax.inject.Inject

@AndroidEntryPoint
class LanguageActivity : AppCompatActivity() {

    private var _bn: ActivityLanguageBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityLanguageBinding.inflate(layoutInflater)
        setContentView(bn.root)
        window.decorView.systemUiVisibility = window.decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR

        bn.apply {
            uzbekLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.UZ)
            }
            russianLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.RU)
            }
            englishLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.EN)
            }
        }
    }

    private fun setLangAndNavigate(lang: String) {
        pref.language = lang
        startActivity(Intent(this@LanguageActivity, AuthActivity::class.java))
        finish()
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}