package com.mobiuz.app

import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import com.mobiuz.app.databinding.ActivitySplashBinding
import com.mobiuz.app.model.SharedPref
import com.mobiuz.app.ui.global.CONSTANTS
import javax.inject.Inject

@AndroidEntryPoint
class SplashActivity : AppCompatActivity() {

    private var _bn: ActivitySplashBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivitySplashBinding.inflate(layoutInflater)
        setContentView(bn.root)

        lifecycleScope.launchWhenCreated {
            delay(1000)
            when {
                pref.language.isEmpty() -> {
                    startActivity(Intent(this@SplashActivity, LanguageActivity::class.java))
                }

                !pref.isRegistered -> {
                    startActivity(Intent(this@SplashActivity, AuthActivity::class.java))
                }

                pref.pin_code.isEmpty() -> {
                    startActivity(Intent(this@SplashActivity, AuthActivity::class.java).putExtra(CONSTANTS.TYPE_AUTH, CONSTANTS.PIN_CODE))
                }

                else -> {
                    startActivity(Intent(this@SplashActivity, MainActivity::class.java))
                }
            }
            finish()
        }
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}