package com.mobiuz.app.ui.home

import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import com.mobiuz.app.AuthActivity
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentHomeBinding
import com.mobiuz.app.model.SharedPref
import com.mobiuz.app.network.model.Customer
import com.mobiuz.app.network.model.UiStateObject
import com.mobiuz.app.ui.base.BaseFragment
import com.mobiuz.app.ui.global.ButtonClick
import com.mobiuz.app.utils.extensions.*
import javax.inject.Inject


@AndroidEntryPoint
class HomeFragment : BaseFragment(R.layout.fragment_home) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentHomeBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val viewModel: HomeViewModel by viewModels()

    private var customer: Customer? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        viewModel.mainIndex()
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentHomeBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            btnMenu.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    showCustomExitDialog {
                        pref.setUserToken("")
                        pref.isRegistered = false
                        pref.pin_code = ""
                        val intent = Intent(requireContext(), AuthActivity::class.java)
                        intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                        startActivity(intent)
                        requireActivity().finish()
                    }
                }
            })
            btnAddSum.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {

                }
            })
        }
    }

    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.mainIndexUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {
                        showProgressDialog(false)
                        customer = it.data
                        loadData()
                    }
                    is UiStateObject.ERROR -> {
                        showProgressDialog(false)
//                        showCustomDialog(it.message,false){}
                    }

                    is UiStateObject.ERRORS -> {
                        showProgressDialog(false)
                    }
                    is UiStateObject.LOADING -> {
                        showProgressDialog(true)
                    }
                    else -> Unit
                }
            }
        }
    }

    @SuppressLint("SetTextI18n")
    private fun loadData() {
        try {
            customLog("customer:$customer")
            customer?.customer?.info?.let {
                bn.apply {
                    txtBalance.text = "${it.balance?.amount?.toMoneyFormat()} ${it.balance?.currency}"
                    it.counters.let {
                        txtCountMb.text = it?.BYTE?.value?.toMoneyFormat() ?: "0"
                        txtTypeMb.text = it?.BYTE?.unit ?: "mb"

                        txtCountMinut.text = it?.SECOND?.value?.toMoneyFormat() ?: "0"
                        txtTypeMinut.text = it?.SECOND?.unit ?: "min"

                        txtCountSms.text = it?.ITEM?.value?.toMoneyFormat() ?: "0"
                        txtTypeSms.text = it?.ITEM?.unit ?: "sms"
                    }
                    txtMyNumber.text = pref.userPhone
                }
            }
        } catch (e: Exception) {
            showCustomDialog(e.userMessage(requireContext()), false) {}
        }


    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}