package com.mobiuz.app.ui.home

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import com.mobiuz.app.network.model.Customer
import com.mobiuz.app.network.model.UiStateObject
import com.mobiuz.app.network.repository.AuthRepository
import javax.inject.Inject

@HiltViewModel
class HomeViewModel @Inject constructor(
    private val repository: AuthRepository
) : ViewModel() {

    private val _mainIndexUiState = MutableStateFlow<UiStateObject<Customer>>(UiStateObject.EMPTY)
    val mainIndexUiState: StateFlow<UiStateObject<Customer>> = _mainIndexUiState

    fun mainIndex() = viewModelScope.launch {
        _mainIndexUiState.value = UiStateObject.LOADING
        _mainIndexUiState.value = repository.mainIndex()
    }

}