package com.mobiuz.app.dev.ui.service

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.mobiuz.app.databinding.ItemServiceBinding
import com.mobiuz.app.dev.model.ServiceData
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.utils.extensions.SingleBlock
import com.mobiuz.app.dev.utils.extensions.getCurrentName

class ServiceAdapter(val lang: String) : RecyclerView.Adapter<ServiceAdapter.VHolder>() {

    private val list: ArrayList<ServiceData> by lazy { ArrayList() }
    private var listener: SingleBlock<ServiceData>? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): VHolder {
        return VHolder(ItemServiceBinding.inflate(LayoutInflater.from(parent.context)))
    }

    override fun onBindViewHolder(holder: VHolder, position: Int) = holder.bind(position)
    override fun getItemCount() = list.size

    inner class VHolder(private val binding: ItemServiceBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(position: Int) {
            val d = list[position]
            binding.apply {

                txtTitle.text = d.title.getCurrentName(lang)
                txtDescription.text = d.short_description.getCurrentName(lang)
                cardView.setOnClickListener(object : ButtonClick() {
                    override fun onSingleClick(v: View?) {
                        listener?.invoke(d)
                    }
                })
            }
        }
    }

    fun submitList(ls: List<ServiceData>) {
        list.clear()
        list.addAll(ls)
        notifyDataSetChanged()
    }


    fun setOnClickListener(block: SingleBlock<ServiceData>) {
        listener = block
    }

}