package uz.ssd.mobiuz.ui.global

import android.os.Bundle
import android.view.View
import android.view.animation.AnimationUtils
import android.widget.TextView
import androidx.core.view.isVisible
import androidx.fragment.app.DialogFragment
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.databinding.FragmentPinDialogBinding
import uz.ssd.mobiuz.model.PinData
import uz.ssd.mobiuz.model.SharedPref
import uz.ssd.mobiuz.ui.auth.pin.PinAdapter
import uz.ssd.mobiuz.utils.extensions.SingleBlock
import javax.inject.Inject


@AndroidEntryPoint
class FullScreenDialog : DialogFragment(R.layout.fragment_pin_dialog) {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: FragmentPinDialogBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val data = ArrayList<PinData>()
    private val pinAdapter = PinAdapter()
    private var listener: SingleBlock<Unit>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NO_TITLE,R.style.FullScreenDialog)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentPinDialogBinding.bind(view)

        isCancelable = false
        setUpUI()

    }

    fun setUpUI() {
        bn.apply {
            loadData()
            rvPin.layoutManager = LinearLayoutManager(requireContext(), LinearLayoutManager.HORIZONTAL, false)

            withPassword.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    listener?.invoke(Unit)
                }
            })
            rvPin.adapter = pinAdapter
            txtNotPin.isVisible = false
            pinAdapter.setOnDoneListener {
                lifecycleScope.launchWhenCreated {
                    delay(200)
                    if (pref.pin_code == it) {
                        txtNotPin.isVisible = false
                        dismiss()
                    } else {
                        cardPin.startAnimation(AnimationUtils.loadAnimation(context, R.anim.shake))
                        txtNotPin.isVisible = true
                    }
                }

            }


            for (i in 0 until btnViewGroup.childCount) {
                btnViewGroup.getChildAt(i).setOnClickListener {
                    if (it.id == R.id.btn_remove) {
                        pinAdapter.removeItem()
                        txtNotPin.isVisible = false
                    } else {
                        val text = it as TextView
                        pinAdapter.addItem(text.text.toString().toInt())
                    }
                }
            }

        }
    }


    private fun loadData() {
        data.clear()
        for (i in 0..3) {
            data.add(PinData(-1))
        }
        pinAdapter.submitList(data)
    }

    fun setOnPinDoneListener(block: SingleBlock<Unit>) {
        listener = block
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}

