package com.mobiuz.app.dev.network.api

import com.mobiuz.app.dev.model.ServiceData
import com.mobiuz.app.dev.model.UserAuth
import com.mobiuz.app.dev.network.model.*
import retrofit2.http.Body
import retrofit2.http.POST


interface ApiService {

    @POST("customer/login")
    suspend fun login(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST("customer/register")
    suspend fun register(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST("customer/check-phone")
    suspend fun checkPhone(
        @Body req: UserAuth
    ): ResponseObject<Action>

    @POST("customer/check-sms-code")
    suspend fun checkSMSCode(
        @Body req: UserAuth
    ): ResponseObject<GenerateToken>

    @POST("main/index")
    suspend fun mainIndex(): ResponseObject<Customer>

    @POST("customer/forget-password")
    suspend fun forgetPassword(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST("customer/check-reset-code")
    suspend fun checkResetCode(
        @Body req: UserAuth
    ): Response

    @POST("customer/reset-password")
    suspend fun resetPassword(
        @Body req: UserAuth
    ): ResponseObject<GenerateToken>

    @POST("customer/log-out")
    suspend fun logOut(): Response

    @POST("customer/send-sms-code")
    suspend fun reSendSms(
        @Body req: UserAuth
    ): ResponseObject<String>

    @POST("customer/check-password")
    suspend fun checkPassword(
        @Body req: UserAuth
    ): Response

    @POST("customer/change-password")
    suspend fun installPassword(
        @Body req: ChangePassword
    ): Response

    @POST("service/index")
    suspend fun getServices(): ResponseList<ServiceData>


}