package com.mobiuz.app.dev.ui.settings.safety

import android.os.Bundle
import android.view.View
import android.widget.SeekBar
import androidx.core.os.bundleOf
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentSafetyBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.ui.global.CONSTANTS
import com.mobiuz.app.dev.utils.Utils
import com.mobiuz.app.dev.utils.extensions.showMessage
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class SafetyFragment : BaseFragment(R.layout.fragment_safety) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentSafetyBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentSafetyBinding.bind(view)
        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }
            val text = getString(R.string.settings_safety)
            val myText = text.replace(CONSTANTS.DEFAULT_PHONE,pref.userPhone)
            txtPhoneSafety.text = myText
            switchBiometria.isChecked = pref.isUseFingerPrint
            switchBiometria.setOnCheckedChangeListener { _, isChecked ->
                val message = if(isChecked) "Biometric enabled" else "Biometric disabled"
                showToastMessage(message)
                pref.isUseFingerPrint = isChecked
            }
            btn1.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            btnChangePin.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    navController.navigate(R.id.pinFragment, bundleOf(CONSTANTS.TYPE_PIN  to CONSTANTS.CURRENT_PIN), Utils.navOptions())
                }
            })
            btnChangePassword.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    navController.navigate(R.id.currentPasswordFragment, bundleOf(CONSTANTS.TYPE_PASSWORD to CONSTANTS.CURRENT_PASSWORD),Utils.navOptions())
                }
            })
            btn4.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            btn5.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            seekbar.setOnSeekBarChangeListener(object : SeekBar.OnSeekBarChangeListener{
                override fun onProgressChanged(seekBar: SeekBar?, progress: Int, fromUser: Boolean) {

                }

                override fun onStartTrackingTouch(seekBar: SeekBar?) {

                }

                override fun onStopTrackingTouch(seekBar: SeekBar?) {
                    showMessage("${seekBar}")
                }
            })
        }
    }


    override fun collects() {
    }


    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}