package uz.mobiuz.mobiservice.dev.network.repository

import android.content.Context
import com.google.gson.Gson
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.network.api.ApiService
import uz.mobiuz.mobiservice.dev.network.model.Customer
import uz.mobiuz.mobiservice.dev.network.model.Roaming
import uz.mobiuz.mobiservice.dev.network.model.UiStateObject
import uz.mobiuz.mobiservice.dev.utils.extensions.getMessage
import uz.mobiuz.mobiservice.dev.utils.extensions.userMessage
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import uz.agr.sdk.pgw_core.mobi.MobiUz
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class MainRepository @Inject constructor(
    private val apiService: ApiService,
    private val pref: SharedPref,
    @ApplicationContext val context: Context
){
    suspend fun mainIndex(): UiStateObject<Customer> {
        return try {
            withContext(Dispatchers.IO){
                val res = apiService.mainIndex()
                withContext(Dispatchers.Main){
                    when {
                        res.status && res.data != null -> {
                            UiStateObject.SUCCESS(res.data!!)
                        }
                        res.errors.isNotEmpty() -> UiStateObject.ERROR(res.errors.getMessage())
                        else -> UiStateObject.ERROR(res.message)
                    }
                }
            }
        } catch (e: Exception) {
            UiStateObject.ERROR(e.userMessage(context))
        }
    }

    suspend fun logOut() {
         try {
            withContext(Dispatchers.IO){
                MobiUz.deleteAllCards()
                // todo monitoring ni delete qilish kerak
                apiService.logOut()
            }
        } catch (e: Exception) {
           e.printStackTrace()
        }
    }

    suspend fun services(): UiStateObject<String> {
        return try {
            withContext(Dispatchers.IO){
                val res = apiService.getServices()
                withContext(Dispatchers.Main){
                    when {
                        res.status -> {
                            pref.services = Gson().toJson(res.data)
                            UiStateObject.SUCCESS(res.message)
                        }
                        res.errors.isNotEmpty() -> UiStateObject.ERROR(res.errors.getMessage())
                        else -> UiStateObject.ERROR(res.message)
                    }
                }
            }
        } catch (e: Exception) {
            UiStateObject.ERROR(e.userMessage(context))
        }
    }
    suspend fun mainRoaming(): UiStateObject<Roaming> {
        return try {
            withContext(Dispatchers.IO){
                val res = apiService.mainRoaming()
                withContext(Dispatchers.Main){
                    when {
                        res.status -> {
                            UiStateObject.SUCCESS(res.data!!)
                        }
                        res.errors.isNotEmpty() -> UiStateObject.ERROR(res.errors.getMessage())
                        else -> UiStateObject.ERROR(res.message)
                    }
                }
            }
        } catch (e: Exception) {
            UiStateObject.ERROR(e.userMessage(context))
        }
    }



}