package uz.mobiuz.mobiservice.dev.ui.global

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.DialogFragment
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.LayoutExitBinding
import uz.mobiuz.mobiservice.dev.utils.extensions.SingleBlock

class ExitDialog : DialogFragment() {

    private var doneListener: SingleBlock<Boolean>? = null
    private var _bn: LayoutExitBinding? = null
    private val bn get() = _bn!!

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NO_TITLE, R.style.CustomDialog)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _bn = LayoutExitBinding.inflate(inflater, container, false)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        isCancelable = false
        bn.apply {
            btnCancel.setOnClickListener {
                dismiss()
            }
            btnDone.setOnClickListener {
                doneListener?.invoke(true)
                dismiss()
            }
        }

    }

    fun setOnDoneListener(block: SingleBlock<Boolean>) {
        doneListener = block
    }

    override fun onDestroy() {
        super.onDestroy()
        _bn = null
    }
}