package uz.mobiuz.mobiservice.dev.ui.sdk.payment

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.recyclerview.widget.LinearLayoutManager
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import kotlinx.android.synthetic.main.fragment_select_card.*
import uz.agr.sdk.core.entity.card.CardInfo
import uz.agr.sdk.coreui.extension.fadeIn
import uz.agr.sdk.coreui.extension.fadeOut
import uz.agr.sdk.coreui.extension.visible
import uz.agr.sdk.coreui.ui.ButtonClick
import uz.agr.sdk.coreui.ui.decoration.EndOffsetItemDecoration
import uz.agr.sdk.coreui.ui.decoration.StartOffsetItemDecoration
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.ui.sdk.card.CardsListAdapter


/**
 * Created by DostonbekIbragimov on 22/12/2021.
 */
class SelectCardBottomDialogFragment(val cards: List<CardInfo>) : BottomSheetDialogFragment() {

    private var mListener: Listener? = null

    fun setListener(listener: Listener?) {
        this.mListener = listener
    }

    private lateinit var adapter: CardsListAdapter

    override fun onStart() {
        super.onStart()
        val view: FrameLayout = dialog?.findViewById(R.id.design_bottom_sheet)!!
        view.layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT
        val behavior = BottomSheetBehavior.from(view)
        behavior.peekHeight = 3000
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        behavior.addBottomSheetCallback(object : BottomSheetBehavior.BottomSheetCallback() {
            override fun onStateChanged(bottomSheet: View, newState: Int) {
                when (newState) {
                    BottomSheetBehavior.STATE_EXPANDED -> {
                    }
                    BottomSheetBehavior.STATE_COLLAPSED -> {
                    }
                    BottomSheetBehavior.STATE_DRAGGING -> {
                    }
                    BottomSheetBehavior.STATE_SETTLING -> {
                    }
                    BottomSheetBehavior.STATE_HIDDEN -> {
                    }
                }
            }

            override fun onSlide(bottomSheet: View, slideOffset: Float) {}
        })
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View =
        inflater.inflate(R.layout.fragment_select_card, container, false)

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        adapter = CardsListAdapter(true)
//        behavior.isDraggable = true
        /* btnRechargeCard.setOnClickListener {
             dismiss()
             mListener?.onClickRechargeCard()
         }
         btnCardDetails.setOnClickListener {
             dismiss()
             mListener?.onClickCardDetails()
         }
         btnDeleteCard.setOnClickListener {
             dismiss()
             mListener?.onClickDeleteCard()
         }*/

        adapter.setOnClickListener { cardInfo, position ->
            mListener?.onClickCardSelected(cardInfo, position)
            dismiss()
        }

        btnEnterAnotherCard.setOnClickListener(object : ButtonClick() {
            override fun onSingleClick(v: View?) {
                dismiss()
                mListener?.onClickAnotherCard()
            }
        })

        toolbar.setNavigationOnClickListener {
            dismiss()
            mListener?.onClickCancel()
        }

        recyclerView.apply {
            layoutManager = LinearLayoutManager(context)
            setHasFixedSize(true)
            adapter = this@SelectCardBottomDialogFragment.adapter
            visible(false)
        }
        recyclerView.addItemDecoration(StartOffsetItemDecoration(resources.getDimensionPixelOffset(R.dimen.agr_card_list_start_offset)))
        recyclerView.addItemDecoration(EndOffsetItemDecoration(resources.getDimensionPixelOffset(R.dimen.agr_card_list_end_offset)))

        /* toolbar.setNavigationOnClickListener { presenter.onBackPressed() }
         swipeToRefresh.setOnRefreshListener { presenter.refreshCardsInfo() }
         btnEnterAnotherCard.setOnClickListener { presenter.onClickNewCard() }
         zeroViewHolder = ZeroViewHolder(zeroLayout) { presenter.refreshCardsInfo() }
         noCardsViewHolder = NoCardsViewHolder(emptyLayout)
         btnEnterAnotherCard.visible(selectCard)*/

        if (cards.isNotEmpty()) recyclerView.fadeIn()
        else recyclerView.fadeOut()
//        swipeToRefresh.isEnabled = cards.isNotEmpty()
        adapter.setData(cards)
        adapter.notifyDataSetChanged()
    }

    interface Listener {
        fun onClickAnotherCard()
        fun onClickCancel()
        fun onClickCardSelected(cardInfo: CardInfo, position: Int)
    }
}