package uz.ssd.mobiuz

import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.view.WindowManager
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import uz.ssd.mobiuz.databinding.ActivitySplashBinding
import uz.ssd.mobiuz.model.SharedPref
import javax.inject.Inject

@AndroidEntryPoint
class SplashActivity : AppCompatActivity() {
    private var _bn: ActivitySplashBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivitySplashBinding.inflate(layoutInflater)
        setContentView(bn.root)

        window.navigationBarColor = this.resources.getColor(R.color.red_dark)
        lifecycleScope.launchWhenCreated {
            delay(1000)
            if (pref.language.isEmpty()) {
                startActivity(Intent(this@SplashActivity, LanguageActivity::class.java))
            } else {
                startActivity(Intent(this@SplashActivity, LanguageActivity::class.java))
            }
            finish()
        }
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}